// AP2VIEW.H
//

#ifndef __AP2VIEW_H
#define __AP2VIEW_H

#include <coecntrl.h>

#include "EmuApple.h"

typedef unsigned char TCharRow[40];

class TAppleHiresLUT;

class CAppleIIView : public CCoeControl
	{
public:
	// construct/destruct
	CAppleIIView(const CCoeControl* aParent, const TRect& aRect, TAppleII* iModel);
	void ConstructL();
	~CAppleIIView();
	TInt Render();
protected:
	TAppleII* iModel;
private: // framework
	virtual void Draw(const TRect& /* aRect */) const; // draw model
	void RenderTextLine(TInt y, const TCharRow charrow);
	void RenderLoresLine(TInt y, const TCharRow charrow);
	TInt DrawTextLine(TInt y, TBool flash);
	TInt DrawLoresLine(TInt y);
	TInt DrawHiresLines(TInt y, TInt maxy);
private:
	CFbsBitmap* iBitmap;
	TSize iBitmapSize;
	const CCoeControl* iParent;
	TRect iOfferedRect;
	TBool invert;
	TAppleHiresLUT* colors_lut;
	TInt lastgrmode;
	TBool lastflash;
	//byte textbuf[24][80];
	};

#endif
